
<!-- Pricing Section Starts Here -->
<section class="pricing-section padding-bottom padding-top">
    <div class="container">
        <?php if(isset($planCaption['plan'][0]) && $caption = $planCaption['plan'][0]): ?>
            <div class="row justify-content-center">
            <div class="col-xl-6 col-lg-7 col-md-10">
                <div class="section-header text-center">
                    <span class="section-header_subtitle"><?php echo app('translator')->get($caption['description']->sub_title); ?></span>
                    <h2 class="section-header_title"><?php echo app('translator')->get($caption['description']->heading); ?> <span class="text--base"> <?php echo app('translator')->get($caption['description']->highlight_heading); ?></span></h2>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <ul class="nav nav-tabs nav--tabs">
            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=> $miner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li>
                <a href="#tab-<?php echo e($k); ?>" <?php if($k ==0): ?>class="active" <?php endif; ?> data-bs-toggle="tab"><?php echo e($miner->name); ?></a>
            </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <div class="tab-content">
            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=> $miner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="tab-pane show fade <?php if($k ==0): ?> active <?php endif; ?>" id="tab-<?php echo e($k); ?>">
                <div class="row g-4 justify-content-center">
                    <?php $__currentLoopData = $miner->plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-4 col-sm-6">
                        <div class="pricing-card">
                            <div class="pricing-card__icon">
                                <img src="<?php echo e(getFile(config('location.plan.path').$item->image)); ?>" alt="images">
                            </div>
                            <h5 class="pricing-card__title"><?php echo app('translator')->get($item->name); ?></h5>
                            <div class="price-body">
                                <span><?php echo app('translator')->get('Price'); ?></span>
                                <h3 class="price"><?php echo e(getAmount($item->price)); ?> <?php echo app('translator')->get(config('basic.currency')); ?></h3>
                            </div>
                            <ul class="info">
                                <li>
                                    <span class="sub-info-title"><?php echo app('translator')->get('Duration'); ?></span>
                                    <h6 class="sub-info"><?php echo app('translator')->get('For'); ?> <?php echo e($item->duration); ?> <?php echo e($item->periodText); ?></h6>
                                </li>

                                <?php if(config('basic.plan_sale_commission') == 1): ?>
                                    <li>
                                        <span class="sub-info-title"><?php echo app('translator')->get('Referral'); ?></span>
                                        <h6 class="sub-info"><?php echo e($item->referral); ?>%</h6>
                                    </li>
                                <?php endif; ?>
                                <li>
                                    <span class="sub-info-title"><?php echo app('translator')->get('Hashrate'); ?></span>
                                    <h6 class="sub-info"><?php echo e($item->hash_rate_speed.' '.trans($item->hash_rate_unit)); ?></h6>
                                </li>
                            </ul>
                            <a href="javascript:void(0)"
                               data-bs-backdrop='static' data-keyboard='false'
                               data-bs-toggle="modal" data-bs-target="#addFundModal"
                               data-id="<?php echo e($item->id); ?>"
                               data-name="<?php echo e($item->name); ?>"
                               data-price="<?php echo e($item->price); ?>"
                               class="cmn--btn active shadow-base addFund"><?php echo app('translator')->get('Buy Now'); ?></a>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<!-- Pricing Section Ends Here -->



<?php $__env->startPush('loadModal'); ?>
    <div id="addFundModal" class="modal fade addFundModal custom--modal modal-danger" tabindex="-1" role="dialog"
         data-bs-backdrop="static" data-bs-keyboard="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content form-block gradient-bg">
                <form action="<?php echo e(route('user.plan-order')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h6 class="modal-title plan-name"></h6>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true" class="white-text">&times;</span>
                        </button>
                    </div>

                    <div class="modal-body ">
                        <div class="payment-form  deposit-preview-body ">

                            <input type="hidden" class="plan_id" name="plan_id" value="<?php echo e(old('plan_id')); ?>" >
                            <div class="form-group mt-3">
                                <label><?php echo app('translator')->get('Plan Price'); ?></label>
                                <div class="input-group input-group-lg">
                                    <input type="text" class="amount form-control form--control style--two"
                                           name="amount" value="<?php echo e(old('amount')); ?>" readonly>
                                    <div class="input-group-append ">
                                            <span
                                                class="input-group-text form--control style--two show-currency"></span>
                                    </div>
                                </div>
                                <pre class="text-danger errors"></pre>
                            </div>

                            <div class="form-group mt-3">
                                <label><?php echo app('translator')->get('Payment Type'); ?></label>
                                <select class="form-control form--control style--two" name="payment_type">
                                    <option value="" selected disabled><?php echo app('translator')->get('Select One'); ?></option>
                                    <option value="0" <?php echo e(old('payment_type') == '0' ? 'select' : ''); ?>><?php echo app('translator')->get('Pay Via Online'); ?></option>
                                    <option value="1" <?php echo e(old('payment_type') == '1' ? 'select' : ''); ?>><?php echo app('translator')->get('Pay Via Fund'); ?></option>

                                </select>
                            </div>

                        </div>

                    </div>
                    <div class="modal-footer border-top-0">
                        <button type="submit" class="btn btn--md btn--success checkCalc"><?php echo app('translator')->get('Pay Now'); ?></button>
                    </div>

                </form>

            </div>
        </div>
    </div>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>

    <script>
        $('#loading').hide();
        "use strict";
        var id, name, price, baseSymbol, currency;
        $('.addFund').on('click', function () {
            id = $(this).data('id');
            name = $(this).data('name');
            price = $(this).data('price');
            baseSymbol = "<?php echo e(config('basic.currency_symbol')); ?>";
            $('.plan-name').text(`${name}`);
            $('.show-currency').text("<?php echo e(config('basic.currency')); ?>");
            $('.amount').val(price);
            $('.plan_id').val(id);
        });


        $('.close').on('click', function (e) {
            $("#addFundModal").modal("hide");
        });

    </script>

    <?php if(count($errors) > 0 ): ?>
        <script>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            Notiflix.Notify.Failure("<?php echo app('translator')->get($error); ?>");
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\server\htdocs\codecanyon-D9E8xWGL-minestack-a-digital-mining-platform\project\resources\views/themes/royalblue/sections/plan.blade.php ENDPATH**/ ?>