<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <?php echo $__env->make('partials.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@100;200;300;400;500;600;700&family=Open+Sans:wght@300;400&display=swap">
    <!-- bootstrap 5  -->
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/lib/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/lib/animate.css')); ?>">
    <?php echo $__env->yieldPushContent('css-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/line-awesome.min.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/lib/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/lib/odometer.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/main.css')); ?>">
    <?php echo $__env->yieldPushContent('style'); ?>
</head>
<body>

<div class="overlay"></div>
<a href="javascript:void(0)" class="scrollToTop"><i class="las la-chevron-up"></i></a>
<?php echo $__env->make($theme.'partials.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="header">
    <div class="header-bottom">
        <div class="container">
            <div class="header-bottom-area">
                <div class="logo">
                    <a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(getFile(config('location.logoIcon.path').'logo.png')); ?>"
                                                alt="<?php echo e(config('basic.site_title')); ?>"></a>
                </div>

                <ul class="menu">
                    <li><a href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a></li>
                    <li><a href="<?php echo e(route('plan')); ?>"><?php echo app('translator')->get('Plan'); ?></a></li>
                    <li><a href="<?php echo e(route('about')); ?>"><?php echo app('translator')->get('About Us'); ?></a></li>
                    <li><a href="<?php echo e(route('blog')); ?>"><?php echo app('translator')->get('Blog'); ?></a></li>
                    <li><a href="<?php echo e(route('faq')); ?>"><?php echo app('translator')->get('FAQ'); ?></a></li>
                    <li><a href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a></li>


                    <?php if(auth()->guard()->guest()): ?>
                        <li class="d-sm-none d-block "><a href="<?php echo e(route('login')); ?>"><?php echo app('translator')->get('Sign In'); ?></a></li>
                        <li class="d-sm-none d-block "><a href="<?php echo e(route('register')); ?>"><?php echo app('translator')->get('Sign Up'); ?></a></li>
                        <li class="p-0 mx-lg-3 my-2 my-lg-0 d-none d-lg-block">
                            <a href="<?php echo e(route('login')); ?>"
                               class="cmn--btn btn--md btn--round <?php if(request()->routeIs('login')): ?> active <?php endif; ?> shadow-base"><?php echo app('translator')->get('Sign In'); ?></a>
                        </li>
                        <li class="p-0 mx-lg-3 my-2 my-lg-0 d-none d-lg-block">
                            <a href="<?php echo e(route('register')); ?>"
                               class="cmn--btn btn--md btn--round  <?php if(request()->routeIs('register')): ?> active <?php endif; ?> shadow-base"><?php echo app('translator')->get('Sign Up'); ?></a>
                        </li>
                    <?php endif; ?>


                    <?php if(auth()->guard()->check()): ?>
                        <li class="d-lg-none d-block "><a href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a></li>
                        <li class="d-lg-none d-block "><a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                         document.getElementById('logout-form').submit();"><?php echo app('translator')->get('Logout'); ?></a></li>

                        <li class="p-0 d-none d-lg-block mx-lg-3 my-2">
                            <a href="javascript:void(0)" class="dashboard-link p-0"><img
                                    src="<?php echo e(getFile(config('location.user.path').auth()->user()->image)); ?>"
                                    alt="dashboard-link"></a>

                            <ul class="sub-menu">
                                <li><a href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a></li>
                                <li><a href="<?php echo e(route('user.twostep.security')); ?>"><?php echo app('translator')->get('2FA Security'); ?></a></li>
                                <li><a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                         document.getElementById('logout-form').submit();"><?php echo app('translator')->get('Logout'); ?></a></li>
                            </ul>
                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                <?php echo csrf_field(); ?>
                            </form>
                        </li>
                    <?php endif; ?>

                    <li class="p-0 d-none d-lg-block mx-lg-3 my-2">
                    </li>

                </ul>

                <div class="header-trigger-wrapper d-flex d-lg-none align-items-center">
                    <?php if(auth()->guard()->check()): ?>
                        <div class="p-0  d-lg-block mx-lg-3 my-2">
                            <a href="javascript:void(0)" class="dashboard-link p-0"><img
                                    src="<?php echo e(getFile(config('location.user.path').auth()->user()->image)); ?>"
                                    alt="dashboard-link"></a>

                        </div>
                        <div class="p-0  d-lg-block mx-3 my-2">
                        </div>
                    <?php endif; ?>

                    <?php if(auth()->guard()->guest()): ?>
                        <div class="me-3 me-lg-0 d-none d-sm-block">
                            <a href="<?php echo e(route('login')); ?>"
                               class="cmn--btn btn--sm btn--round active shadow-base"><?php echo app('translator')->get('Sign In'); ?></a>
                            <a href="<?php echo e(route('register')); ?>"
                               class="cmn--btn btn--sm btn--round  shadow-base"><?php echo app('translator')->get('Sign Up'); ?></a>
                        </div>
                    <?php endif; ?>
                    <div class="header-trigger d-block d--none">
                        <span></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php echo $__env->make($theme.'partials.banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->yieldContent('content'); ?>


<?php echo $__env->make($theme.'partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<?php echo $__env->yieldPushContent('extra-content'); ?>
<?php echo $__env->yieldPushContent('loadModal'); ?>

<script src="<?php echo e(asset($themeTrue.'js/lib/jquery-3.6.0.min.js')); ?>"></script>


<script src="<?php echo e(asset($themeTrue.'js/lib/bootstrap.min.js')); ?>"></script>
<?php echo $__env->yieldPushContent('extra-js'); ?>
<script src="<?php echo e(asset($themeTrue.'js/lib/slick.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/lib/odometer.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/lib/viewport.jquery.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/notiflix-aio-2.7.0.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/pusher.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/vue.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/axios.min.js')); ?>"></script>


<script src="<?php echo e(asset($themeTrue.'js/main.js')); ?>"></script>
<?php if(auth()->guard()->check()): ?>

<?php endif; ?>
<?php echo $__env->yieldPushContent('script'); ?>

<?php echo $__env->make($theme.'partials.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>
</html>
<?php /**PATH D:\server\htdocs\codecanyon-D9E8xWGL-minestack-a-digital-mining-platform\project\resources\views/themes/royalblue/layouts/app.blade.php ENDPATH**/ ?>