<?php $__env->startSection('title', trans($title)); ?>
<?php $__env->startSection('content'); ?>

    <!-- Dashboard Starts Here -->
    <div class="dashboard-section padding-top padding-bottom">
        <div class="container">
            <div class="row justify-content-center g-4">

                <?php $__currentLoopData = $wallets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wallet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-4 col-lg-4 col-md-6 col-sm-10">
                        <div class="dashboard__card dashboard__card-<?php echo e(strtoupper($wallet->code)); ?>">
                            <div class="w-100 text-center">
                                <h4 class="title text-white mb-4"><?php echo e(trans(optional($wallet->miner)->name)); ?> <?php echo app('translator')->get('Wallet'); ?></h4>

                            </div>
                            <div class="dashboard__card-content">
                                <h2 class="price"><?php echo e(getAmount($wallet->balance,8)); ?></h2>
                                <p class="info"><?php echo e($wallet->code); ?> <?php echo app('translator')->get('Balance'); ?></p>
                            </div>
                            <div class="dashboard__card-icon dashboard__card-icon-<?php echo e(strtoupper($wallet->code)); ?>">
                                <?php if(file_exists('assets/crypto/'.strtoupper($wallet->code).'.png') ): ?>
                                    <img src="<?php echo e(asset('assets/crypto/'.strtoupper($wallet->code).'.png')); ?>" alt="<?php echo e($wallet->code); ?>" >
                                <?php else: ?>
                                    <i class="ci ci-<?php echo e(strtolower($wallet->code)); ?>"></i>
                                <?php endif; ?>
                            </div>

                            <div class="deposit-preview-body px-1 py-4">

                                <div class="deposit-group">
                                    <h6 class="title"><?php echo app('translator')->get('Address'); ?>:</h6>
                                    <div class="value">
                                        <?php if($wallet->wallet_address): ?>
                                            <span class="walletAddress"> <?php echo e($wallet->wallet_address); ?> </span>
                                        <?php else: ?>
                                            <span class="emptyAddress"><?php echo app('translator')->get("Please update your wallet address"); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="deposit-group">
                                    <h6 class="title"><?php echo app('translator')->get('Min. Limit'); ?> :</h6>
                                    <div class="value">
                                        <?php echo e(getAmount(optional($wallet->miner)->minimum_amount,8)); ?> <?php echo e(strtoupper($wallet->code)); ?>

                                    </div>
                                </div>
                                <div class="deposit-group">
                                    <h6 class="title"><?php echo app('translator')->get('Max. Limit'); ?> :</h6>
                                    <div class="value">
                                        <?php echo e(getAmount(optional($wallet->miner)->maximum_amount,8)); ?>  <?php echo e(strtoupper($wallet->code)); ?>

                                    </div>
                                </div>


                                <div class="text-center mt-4">
                                    <?php if($wallet->wallet_address): ?>
                                    <a href="javascript:void(0)"
                                       data-bs-backdrop='static' data-keyboard='false'
                                       data-bs-toggle="modal" data-bs-target="#addFundModal"
                                       data-wallet="<?php echo e(optional($wallet->miner)->name); ?>"
                                       data-code="<?php echo e($wallet->code); ?>"
                                       data-id="<?php echo e($wallet->id); ?>"

                                       class="btn btn--base justify-content-center btn--block addFund"><?php echo app('translator')->get('Payout Now'); ?></a>
                                    <?php else: ?>
                                        <a href="<?php echo e(route('user.wallet')); ?>" class="btn btn--base justify-content-center btn--block"><?php echo app('translator')->get('Upgrade Wallet Address'); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

        </div>
        <div class="shape shape1">
            <img src="<?php echo e(getFile($themeTrue.'images/about/shape2.png')); ?>" alt="about">
        </div>
    </div>
    <!-- Dashboard Ends Here -->





    <?php $__env->startPush('loadModal'); ?>
        <div id="addFundModal" class="modal fade addFundModal custom--modal modal-danger" tabindex="-1" role="dialog"
             data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog" role="document">
                <div class="modal-content form-block gradient-bg">
                    <form action="<?php echo e(route('user.payout.moneyRequest')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="modal-header">
                            <h6 class="modal-title"></h6>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true" class="white-text">&times;</span>
                            </button>
                        </div>

                        <div class="modal-body ">
                            <div class="payment-form  deposit-preview-body ">
                                <input type="hidden" class="wallet" name="wallet" value="<?php echo e(old('wallet')); ?>" >
                                <div class="form-group mt-3">
                                    <label><?php echo app('translator')->get('Enter Amount'); ?></label>
                                    <div class="input-group input-group-lg">
                                        <input type="text" class="amount form-control form--control style--two" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')"
                                               name="amount" value="<?php echo e(old('amount')); ?>" placeholder="0.00">
                                        <div class="input-group-append ">
                                            <span
                                                class="input-group-text form--control  show-currency"></span>
                                        </div>
                                    </div>
                                    <pre class="text-danger errors"></pre>
                                </div>



                            </div>

                        </div>
                        <div class="modal-footer border-top-0">
                            <button type="button" class="btn btn--md btn--danger close"><?php echo app('translator')->get('Cancel'); ?></button>
                            <button type="submit" class="btn btn--md btn--success checkCalc"><?php echo app('translator')->get('Pay Now'); ?></button>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    <?php $__env->stopPush(); ?>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('css-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/coinicon.css')); ?>">
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>

    <script>

        "use strict";
        var wallet;
        $('.addFund').on('click', function () {
            wallet = $(this).data('wallet');
            $('.modal-title').text(`Withdraw from ${wallet} wallet`)
            $('.wallet').val($(this).data('id'))
            $('.show-currency').text($(this).data('code'))
        });

        $('.close').on('click', function (e) {
            $("#addFundModal").modal("hide");
        });


    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/redhosta/demo.redhosta.com/min/resources/views/themes/royalblue/user/payout/money.blade.php ENDPATH**/ ?>