<?php $__env->startSection('title',trans($title)); ?>
<?php $__env->startSection('content'); ?>


    <!-- Dashboard Starts Here -->
    <div class="dashboard-section padding-top padding-bottom">
        <div class="container">

            <table class="table transection__table mt-5">
                <thead>
                <tr>
                    <th><?php echo app('translator')->get('SL No.'); ?></th>
                    <th><?php echo app('translator')->get('REF'); ?></th>
                    <th><?php echo app('translator')->get('PLAN'); ?></th>
                    <th><?php echo app('translator')->get('PRICE'); ?></th>
                    <th><?php echo app('translator')->get('PROFIT'); ?> <small>( <?php echo app('translator')->get('per day'); ?> )</small></th>
                    <th><?php echo app('translator')->get('TOTAL DAYS'); ?></th>
                    <th><?php echo app('translator')->get('REMAIN DAYS'); ?></th>
                    <th><?php echo app('translator')->get('STATUS'); ?></th>
                    <th><?php echo app('translator')->get('MORE'); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td data-label="<?php echo app('translator')->get('SL No.'); ?>"><span
                                class="transection-id"><?php echo e(loopIndex($records) + $loop->index); ?></span></td>
                        <td data-label="<?php echo app('translator')->get('REF'); ?>"><?php echo app('translator')->get($data->transaction); ?></td>
                        <td data-label="<?php echo app('translator')->get('PLAN'); ?>"><?php echo app('translator')->get(@$data->plan_info->Name); ?></td>
                        <td data-label="<?php echo app('translator')->get('PRICE'); ?>"><?php echo app('translator')->get(config('basic.currency_symbol')); ?><?php echo e(getAmount($data->price)); ?></td>
                        <td data-label="<?php echo app('translator')->get('PROFIT'); ?>">
                        <span class="cost text--success">
                            <?php echo e(getAmount($data->maximum_profit ?? $data->minimum_profit,8)); ?> <?php echo app('translator')->get($data->code); ?>
                        </span>
                        </td>
                        <td data-label="<?php echo app('translator')->get('TOTAL DAYS'); ?>" class="text-center"><?php echo e($data->profitable_cycle); ?></td>
                        <td data-label="<?php echo app('translator')->get('REMAIN DAYS'); ?>" class="text-center"><?php echo e($data->remaining_cycle); ?></td>
                        <td data-label="<?php echo app('translator')->get('STATUS'); ?>">
                            <?php if($data->status == 1): ?>
                                <span class="badge bg--success"><?php echo app('translator')->get('Active'); ?></span>
                            <?php elseif($data->status == 2): ?>
                                <span class="badge bg--danger"><?php echo app('translator')->get('Complete'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td data-label="<?php echo app('translator')->get('MORE'); ?>">
                            <button type="button" class="btn btn--primary btn--sm infoButton"
                                    data-bs-backdrop='static' data-keyboard='false'
                                    data-bs-toggle="modal" data-bs-target="#infoModal"
                                    data-plan="<?php echo e(@$data->plan_info->Name); ?>"
                                    data-mining="<?php echo e(@$data->plan_info->Mining); ?>"
                                    data-hashrate="<?php echo e(@$data->plan_info->Hashrate); ?>"
                                    data-duration="<?php echo e(@$data->plan_info->Duration); ?>"
                                    data-price="<?php echo e(@$data->price); ?>"
                                    data-totaldays="<?php echo e(@$data->profitable_cycle); ?>"
                                    data-remaindays="<?php echo e(@$data->remaining_cycle); ?>"
                                    data-transaction="<?php echo e(@$data->transaction); ?>"
                                    data-code="<?php echo e(@$data->code); ?>"
                                    data-status="<?php echo e(($data->status == 1) ? trans('Active') : trans('Complete')); ?>"
                                    data-profit="<?php echo e(getAmount($data->maximum_profit ?? $data->minimum_profit,8)); ?> <?php echo app('translator')->get($data->code); ?>"
                                    data-purchase_at="<?php echo e($data->created_at->format('d M, Y H:i')); ?>">
                                <i class="fas fa-desktop"></i>
                            </button>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr class="text-center">
                        <td colspan="100%"><?php echo e(trans('No Data Found!')); ?></td>
                    </tr>
                <?php endif; ?>

                </tbody>
            </table>

            <?php echo e($records->appends($_GET)->links($theme.'partials.pagination')); ?>

        </div>
        <div class="shape shape1">
            <img src="<?php echo e(getFile($themeTrue.'images/about/shape2.png')); ?>" alt="about">
        </div>
    </div>
    <!-- Dashboard Ends Here -->


    <?php $__env->startPush('loadModal'); ?>
        <div id="infoModal" class="modal fade infoModal custom--modal modal-danger" tabindex="-1" role="dialog"
             data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog" role="document">
                <div class="modal-content form-block gradient-bg">

                    <div class="modal-header">
                        <h6 class="modal-title plan"></h6>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true" class="white-text">&times;</span>
                        </button>
                    </div>

                    <div class="modal-body  gradient-bg p-0">
                        <div class="deposit-preview-body p-4">
                            <div class="deposit-group">
                                <h6 class="title"><?php echo app('translator')->get("REF"); ?> :</h6>
                                <div class="value transaction">
                                </div>
                            </div>
                            <div class="deposit-group">
                                <h6 class="title"><?php echo app('translator')->get("Miner"); ?> :</h6>
                                <div class="value mining">
                                </div>
                            </div>

                            <div class="deposit-group">
                                <h6 class="title"><?php echo app('translator')->get('Price'); ?> :</h6>
                                <div class="value price">
                                </div>
                            </div>

                            <div class="deposit-group">
                                <h6 class="title"><?php echo app('translator')->get('Profit'); ?> :</h6>
                                <div class="value profit">
                                </div>
                            </div>

                            <div class="deposit-group">
                                <h6 class="title"><?php echo app('translator')->get('Hashrate'); ?> :</h6>
                                <div class="value hashrate">
                                </div>
                            </div>

                            <div class="deposit-group">
                                <h6 class="title"><?php echo app('translator')->get('Total Days'); ?> :</h6>
                                <div class="value totaldays">
                                </div>
                            </div>

                            <div class="deposit-group">
                                <h6 class="title"><?php echo app('translator')->get('Remain Days'); ?> :</h6>
                                <div class="value remaindays">
                                </div>
                            </div>
                            <div class="deposit-group">
                                <h6 class="title"><?php echo app('translator')->get('Purchased At'); ?> :</h6>
                                <div class="value purchase_at">
                                </div>
                            </div>

                        </div>

                    </div>
                    <div class="modal-footer border-top-0">
                        <button type="button" class="btn btn--md btn--danger close"><?php echo app('translator')->get('Close'); ?></button>
                    </div>


                </div>
            </div>
        </div>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $('#loading').hide();
        "use strict";

        $('.infoButton').on('click', function () {
            data = $(this).data();


            $('.plan').text(`${data.plan} <?php echo app('translator')->get('Details'); ?>`);
            $('.mining').text(data.mining);
            $('.price').text(`${data.price} <?php echo app('translator')->get(config('basic.currency')); ?>`);

            $('.hashrate').text(data.hashrate);
            $('.duration').text(data.duration);
            $('.totaldays').text(data.totaldays);
            $('.remaindays').text(data.remaindays);
            $('.transaction').text(data.transaction);
            $('.status').text(data.status);
            $('.profit').text(`${data.profit}`);
            $('.purchase_at').text(data.purchase_at);


        });


        $('.close').on('click', function (e) {
            $("#infoModal").modal("hide");
        });

    </script>
    <?php if(count($errors) > 0 ): ?>
        <script>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            Notiflix.Notify.Failure("<?php echo app('translator')->get($error); ?>");
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/redhosta/demo.redhosta.com/min/resources/views/themes/royalblue/user/transaction/purchase.blade.php ENDPATH**/ ?>