<?php $__env->startSection('title',trans('Profile Settings')); ?>

<?php $__env->startSection('content'); ?>
    <!-- Dashboard Starts Here -->
    <div class="dashboard-section padding-top padding-bottom overflow-hidden">
        <div class="container">
            <div class="row gy-5">
                <div class="col-lg-4">
                    <div class="dashboard-user">

                        <form method="post" action="<?php echo e(route('user.updateProfile')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="user-thumb">
                                <img src="<?php echo e(getFile(config('location.user.path').$user->image)); ?>" alt="user"
                                     id="image_preview_container" class="preview-image">

                                <div class="form-group user-up-icon">
                                    <input id="user-up" type="file" name="image" class="form-control d-none">
                                    <label class="user-up" for="user-up"><i class="las la-pen"></i></label>
                                </div>
                            </div>

                            <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <div class="form-group">
                                <button type="submit" class="cmn--btn cmn--btn-sm"><i
                                        class="la la-cloud-upload-alt"></i> <?php echo app('translator')->get('Upload'); ?></button>
                            </div>
                        </form>
                        <div class="user-content">
                            <span><?php echo app('translator')->get('Welcome'); ?></span>
                            <h5 class="name"><?php echo e(ucfirst($user->fullname)); ?></h5>

                            <?php
                                $country = null;
                                $list =collect(config('country'))->where('code',$user->country_code)->collapse();
                                if(isset($list)){
                                    $country = $list['name'];
                                }
                            ?>

                            <ul class="user-info m-0">
                                <?php if($country): ?>
                                    <li>
                                        <i class="las la-globe"></i>
                                        <?php echo app('translator')->get($country); ?>
                                    </li>
                                <?php endif; ?>
                                <?php if($user->email): ?>
                                    <li>
                                        <i class="las la-envelope-open"></i>
                                        <?php echo e($user->email); ?>

                                    </li>
                                <?php endif; ?>
                                <?php if($user->email): ?>
                                    <li>
                                        <i class="las la-phone-volume"></i>
                                        <?php echo e($user->phone); ?>

                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-8">
                    <div class="custom--card card--lg">
                        <div class="card--header gradient-bg-rev d-flex align-items-start justify-content-start">
                            <ul class="nav nav-tabs nav--tabs m-0 text-left">
                                <li>
                                    <a href="#home"
                                       class="<?php echo e($errors->has('profile') ? 'active' : (($errors->has('password') || $errors->has('identity') || $errors->has('addressVerification')) ? '' : ' active')); ?>"
                                       data-bs-toggle="tab"><?php echo app('translator')->get('Profile Information'); ?></a>
                                </li>
                                <li>
                                    <a href="#menu1" class="<?php echo e($errors->has('password') ? 'active' : ''); ?>"
                                       data-bs-toggle="tab"><?php echo app('translator')->get('Password Setting'); ?></a>
                                </li>
                                <li>
                                    <a href="#identity" class="<?php echo e($errors->has('identity') ? 'active' : ''); ?>"
                                       data-bs-toggle="tab"><?php echo app('translator')->get('Identity Verification'); ?></a>
                                </li>

                                <li>
                                    <a href="#addressVerification"
                                       class="<?php echo e($errors->has('addressVerification') ? 'active' : ''); ?>"
                                       data-bs-toggle="tab"><?php echo app('translator')->get('Address Verification'); ?></a>
                                </li>
                            </ul>

                        </div>
                        <div class="card--body gradient-bg">
                            <div class="profile-form-area">

                                <div class="tab-content">
                                    <div class="tab-pane  fade <?php echo e($errors->has('profile') ? 'show active' : (($errors->has('password') || $errors->has('identity') || $errors->has('addressVerification')) ? '' :  'show active')); ?>"
                                        id="home">
                                        <form class="profile-edit-form row gy-3"
                                              action="<?php echo e(route('user.updateInformation')); ?>" method="post">
                                            <?php echo method_field('put'); ?>
                                            <?php echo csrf_field(); ?>
                                            <div class="form--group col-md-6">
                                                <label class="form-label" for="first-name"><?php echo app('translator')->get('First Name'); ?></label>
                                                <input type="text" class="form-control form--control style--two"
                                                       id="first-name" name="firstname"
                                                       value="<?php echo e(old('firstname')?: $user->firstname); ?>">
                                                <?php if($errors->has('firstname')): ?>
                                                    <div
                                                        class="error text-danger"><?php echo app('translator')->get($errors->first('firstname')); ?> </div>
                                                <?php endif; ?>
                                            </div>
                                            <div class="form--group col-md-6">
                                                <label class="form-label" for="last-name"><?php echo app('translator')->get('Last Name'); ?></label>
                                                <input type="text" class="form-control form--control style--two"
                                                       id="last-name" name="lastname"
                                                       value="<?php echo e(old('lastname')?: $user->lastname); ?>">
                                                <?php if($errors->has('lastname')): ?>
                                                    <div
                                                        class="error text-danger"><?php echo app('translator')->get($errors->first('lastname')); ?> </div>
                                                <?php endif; ?>
                                            </div>

                                            <div class="form--group col-md-6">
                                                <label class="form-label" for="last-name"><?php echo app('translator')->get('Username'); ?></label>
                                                <input type="text" class="form-control form--control style--two"
                                                       id="username" name="username"
                                                       value="<?php echo e(old('username')?: $user->username); ?>">
                                                <?php if($errors->has('username')): ?>
                                                    <div
                                                        class="error text-danger"><?php echo app('translator')->get($errors->first('lastname')); ?> </div>
                                                <?php endif; ?>
                                            </div>

                                            <div class="form--group col-md-6">
                                                <label class="form-label" for="email"><?php echo app('translator')->get('Email Address'); ?></label>
                                                <input type="email" class="form-control form--control style--two"
                                                       id="email"
                                                       value="<?php echo e(old('email')?: $user->email); ?>" readonly>
                                                <?php if($errors->has('email')): ?>
                                                    <div
                                                        class="error text-danger"><?php echo app('translator')->get($errors->first('email')); ?> </div>
                                                <?php endif; ?>
                                            </div>

                                            <div class="form--group col-md-6">
                                                <label class="form-label" for="phone"><?php echo app('translator')->get('Phone Number'); ?></label>
                                                <input type="text" class="form-control form--control style--two"
                                                       id="phone"
                                                       value="<?php echo e(old('phone')?: $user->phone); ?>" readonly>
                                                <?php if($errors->has('phone')): ?>
                                                    <div
                                                        class="error text-danger"><?php echo app('translator')->get($errors->first('email')); ?> </div>
                                                <?php endif; ?>
                                            </div>

                                            <div class="form--group col-md-6">
                                                <label class="form-label"
                                                       for="language_id"><?php echo app('translator')->get('Preferred language'); ?></label>
                                                <select name="language_id" id="language_id"
                                                        class="form-control form--control style--two">
                                                    <option value="" disabled><?php echo app('translator')->get('Select Language'); ?></option>
                                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $la): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($la->id); ?>"
                                                            <?php echo e(old('language_id', $user->language_id) == $la->id ? 'selected' : ''); ?>><?php echo app('translator')->get($la->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>

                                                <?php if($errors->has('language_id')): ?>
                                                    <div class="error text-danger"><?php echo app('translator')->get($errors->first('language_id')); ?> </div>
                                                <?php endif; ?>
                                            </div>

                                            <div class="form--group col-md-12">
                                                <label class="form-label" for="address"><?php echo app('translator')->get('Address'); ?></label>
                                                <input type="text" class="form-control form--control style--two"
                                                       id="address" name="address"
                                                       value="<?php echo e(old('address',$user->address)); ?>">
                                                <?php if($errors->has('address')): ?>
                                                    <div
                                                        class="error text-danger"><?php echo app('translator')->get($errors->first('address')); ?> </div>
                                                <?php endif; ?>
                                            </div>
                                            <div class="form--group w-100 col-md-6 mb-0">
                                                <button type="submit"
                                                        class="btn btn--base w-100 mt-3"><?php echo app('translator')->get('Update Information'); ?></button>
                                            </div>
                                        </form>
                                    </div>

                                    <div class="tab-pane fade <?php echo e($errors->has('password') ? 'show active' : ''); ?>"
                                         id="menu1">

                                        <form class="profile-edit-form row gy-3" method="post"
                                              action="<?php echo e(route('user.updatePassword')); ?>">
                                            <?php echo csrf_field(); ?>
                                            <div class="form--group col-md-12">
                                                <label class="form-label"
                                                       for="current_password"><?php echo app('translator')->get('Current Password'); ?></label>
                                                <input id="current_password" type="password"
                                                       class="form-control form--control style--two"
                                                       name="current_password" autocomplete="off">
                                                <?php if($errors->has('current_password')): ?>
                                                    <div
                                                        class="error text-danger"><?php echo app('translator')->get($errors->first('current_password')); ?> </div>
                                                <?php endif; ?>
                                            </div>

                                            <div class="form--group col-md-12">
                                                <label class="form-label"
                                                       for="password"><?php echo app('translator')->get('Current Password'); ?></label>
                                                <input id="password" type="password"
                                                       class="form-control form--control style--two"
                                                       name="password" autocomplete="off">
                                                <?php if($errors->has('password')): ?>
                                                    <div
                                                        class="error text-danger"><?php echo app('translator')->get($errors->first('password')); ?> </div>
                                                <?php endif; ?>
                                            </div>

                                            <div class="form--group col-md-12">
                                                <label class="form-label"
                                                       for="password_confirmation"><?php echo app('translator')->get('Confirm Password'); ?></label>
                                                <input id="password_confirmation" type="password"
                                                       class="form-control form--control style--two"
                                                       name="password_confirmation" autocomplete="off">
                                                <?php if($errors->has('password_confirmation')): ?>
                                                    <div
                                                        class="error text-danger"><?php echo app('translator')->get($errors->first('password_confirmation')); ?> </div>
                                                <?php endif; ?>
                                            </div>

                                            <div class="form--group w-100 col-md-6 mb-0">
                                                <button type="submit"
                                                        class="btn btn--base w-100 mt-3"><?php echo app('translator')->get('Update Password'); ?></button>
                                            </div>
                                        </form>
                                    </div>

                                    <div class="tab-pane show fade <?php echo e($errors->has('identity') ? 'show active' : ''); ?>"
                                         id="identity">
                                        <?php if(in_array($user->identity_verify,[0,3])  ): ?>
                                            <?php if($user->identity_verify == 3): ?>
                                                <div class="alert alert-danger" role="alert">
                                                    <?php echo app('translator')->get('You previous request has been rejected'); ?>
                                                </div>
                                            <?php endif; ?>
                                            <form method="post" action="<?php echo e(route('user.verificationSubmit')); ?>" class="profile-edit-form row gy-3"
                                                  enctype="multipart/form-data">
                                                <?php echo csrf_field(); ?>


                                                <div class="form-group mt-4">
                                                    <label class="form-label" for="identity_type"><?php echo app('translator')->get('Identity Type'); ?></label>
                                                    <select name="identity_type" id="identity_type"
                                                            class="form-control form--control style--two">
                                                        <option value="" selected disabled><?php echo app('translator')->get('Select Type'); ?></option>
                                                        <?php $__currentLoopData = $identityFormList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sForm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option
                                                                value="<?php echo e($sForm->slug); ?>" <?php echo e(old('identity_type', @$identity_type) == $sForm->slug ? 'selected' : ''); ?>><?php echo app('translator')->get($sForm->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <?php $__errorArgs = ['identity_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="error text-danger"><?php echo app('translator')->get($message); ?> </div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                                <?php if(isset($identityForm)): ?>
                                                    <?php $__currentLoopData = $identityForm->services_form; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($v->type == "text"): ?>
                                                            <div class="form-group">
                                                                <label
                                                                    for="<?php echo e($k); ?>"><?php echo e(trans($v->field_level)); ?> <?php if($v->validation == 'required'): ?>
                                                                        <span class="text-danger">*</span>  <?php endif; ?> </label>
                                                                <input type="text" name="<?php echo e($k); ?>"
                                                                       class="form-control form--control style--two"
                                                                       value="<?php echo e(old($k)); ?>" id="<?php echo e($k); ?>"
                                                                       <?php if($v->validation == 'required'): ?> required <?php endif; ?>>

                                                                <?php if($errors->has($k)): ?>
                                                                    <div class="error text-danger"><?php echo app('translator')->get($errors->first($k)); ?> </div>
                                                                <?php endif; ?>


                                                            </div>
                                                        <?php elseif($v->type == "textarea"): ?>
                                                            <div class="form-group">
                                                                <label
                                                                    for="<?php echo e($k); ?>"><?php echo e(trans($v->field_level)); ?> <?php if($v->validation == 'required'): ?>
                                                                        <span
                                                                            class="text-danger">*</span>  <?php endif; ?> </label>
                                                                <textarea name="<?php echo e($k); ?>" id="<?php echo e($k); ?>"
                                                                          class="form-control form--control style--two" rows="5"
                                                                          placeholder="<?php echo e(trans('Type Here')); ?>"
                                                                          <?php if($v->validation == 'required'): ?><?php endif; ?>><?php echo e(old($k)); ?></textarea>
                                                                <?php $__errorArgs = [$k];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <div class="error text-danger">
                                                                    <?php echo e(trans($message)); ?>

                                                                </div>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        <?php elseif($v->type == "file"): ?>
                                                            <div class="form-group">
                                                                <label><?php echo e(trans($v->field_level)); ?> <?php if($v->validation == 'required'): ?>
                                                                        <span class="text-danger">*</span>  <?php endif; ?> </label>

                                                                <br>
                                                                <div class="fileinput fileinput-new "
                                                                     data-provides="fileinput">
                                                                    <div class="fileinput-new thumbnail "
                                                                         data-trigger="fileinput">
                                                                        <img class="w-150px "
                                                                             src="<?php echo e(getFile(config('location.default'))); ?>"
                                                                             alt="...">
                                                                    </div>
                                                                    <div
                                                                        class="fileinput-preview fileinput-exists thumbnail wh-200-150 "></div>

                                                                    <div class="img-input-div">
                                                                    <span class="btn btn-success btn-file">
                                                                        <span
                                                                            class="fileinput-new "> <?php echo app('translator')->get('Select'); ?> <?php echo e($v->field_level); ?></span>
                                                                        <span
                                                                            class="fileinput-exists"> <?php echo app('translator')->get('Change'); ?></span>
                                                                        <input type="file" name="<?php echo e($k); ?>"
                                                                               value="<?php echo e(old($k)); ?>" accept="image/*"
                                                                               <?php if($v->validation == "required"): ?><?php endif; ?>>
                                                                    </span>
                                                                        <a href="#" class="btn btn-danger fileinput-exists"
                                                                           data-dismiss="fileinput"> <?php echo app('translator')->get('Remove'); ?></a>
                                                                    </div>

                                                                </div>

                                                                <?php $__errorArgs = [$k];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <div class="error text-danger">
                                                                    <?php echo e(trans($message)); ?>

                                                                </div>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        <?php endif; ?>

                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    <div class="form-group">
                                                        <button type="submit"
                                                                class=" btn btn--base w-100 mt-3"><?php echo app('translator')->get('Submit'); ?></button>
                                                    </div>
                                                <?php endif; ?>
                                            </form>
                                        <?php elseif($user->identity_verify == 1): ?>
                                            <div class="alert alert-warning" role="alert">
                                                <?php echo app('translator')->get('Your KYC submission has been pending'); ?>
                                            </div>
                                        <?php elseif($user->identity_verify == 2): ?>
                                            <div class="alert alert-success" role="alert">
                                                <?php echo app('translator')->get('Your KYC already verified'); ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="tab-pane  fade <?php echo e($errors->has('addressVerification') ? 'show active' : ''); ?>"
                                         id="addressVerification">
                                        <?php if(in_array($user->address_verify,[0,3])  ): ?>
                                            <?php if($user->address_verify == 3): ?>
                                                <div class="alert alert-danger" role="alert">
                                                    <?php echo app('translator')->get('You previous request has been rejected'); ?>
                                                </div>
                                            <?php endif; ?>
                                            <form method="post" action="<?php echo e(route('user.addressVerification')); ?>" class="profile-edit-form row gy-3"
                                                  enctype="multipart/form-data">
                                                <?php echo csrf_field(); ?>
                                                <div class="form-group">
                                                    <label class="form-label"><?php echo e(trans('Address Proof')); ?> <span class="text-danger">*</span>  </label>

                                                    <br>
                                                    <div class="fileinput fileinput-new "
                                                         data-provides="fileinput">
                                                        <div class="fileinput-new thumbnail "
                                                             data-trigger="fileinput">
                                                            <img class="w-150px "
                                                                 src="<?php echo e(getFile(config('location.default'))); ?>"
                                                                 alt="...">
                                                        </div>
                                                        <div
                                                            class="fileinput-preview fileinput-exists thumbnail wh-200-150 "></div>

                                                        <div class="img-input-div">
                                                                    <span class="btn btn-success btn-file">
                                                                        <span
                                                                            class="fileinput-new "> <?php echo app('translator')->get('Select Image'); ?> </span>
                                                                        <span
                                                                            class="fileinput-exists"> <?php echo app('translator')->get('Change'); ?></span>
                                                                        <input type="file" name="addressProof"
                                                                               value="<?php echo e(old('addressProof')); ?>" accept="image/*">
                                                                    </span>
                                                            <a href="#" class="btn btn-danger fileinput-exists"
                                                               data-dismiss="fileinput"> <?php echo app('translator')->get('Remove'); ?></a>
                                                        </div>

                                                    </div>

                                                    <?php $__errorArgs = ['addressProof'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="error text-danger">
                                                        <?php echo e(trans($message)); ?>

                                                    </div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>


                                                <div class="form-group">
                                                    <button type="submit"
                                                            class=" btn btn--base w-100 mt-3"><?php echo app('translator')->get('Submit'); ?></button>
                                                </div>

                                            </form>
                                        <?php elseif($user->address_verify == 1): ?>
                                            <div class="alert alert-warning" role="alert">
                                                <?php echo app('translator')->get('Your KYC submission has been pending'); ?>
                                            </div>
                                        <?php elseif($user->address_verify == 2): ?>
                                            <div class="alert alert-success" role="alert">
                                                <?php echo app('translator')->get('Your KYC already verified'); ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="shape shape1">
            <img src="<?php echo e(getFile($themeTrue.'images/about/shape2.png')); ?>" alt="about">
        </div>
    </div>
    <!-- Dashboard Ends Here -->


<?php $__env->stopSection(); ?>

<?php $__env->startPush('css-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/bootstrap-fileinput.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('extra-js'); ?>
    <script src="<?php echo e(asset($themeTrue.'js/bootstrap-fileinput.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        $(document).on('change', '#user-up', function () {
            var _this = $(this);
            var newimage = new FileReader();
            newimage.readAsDataURL(this.files[0]);
            newimage.onload = function (e) {
                $('#image_preview_container').attr('src', e.target.result);
            }
        });


        $(document).on('click', '.clickShowPassword', function () {
            var passInput = $(this).closest('.input-group').find('input');
            if (passInput.attr('type') === 'password') {
                $(this).children().addClass('fa-eye');
                $(this).children().removeClass('fa-eye-slash');
                passInput.attr('type', 'text');
            } else {
                $(this).children().addClass('fa-eye-slash');
                $(this).children().removeClass('fa-eye');
                passInput.attr('type', 'password');
            }
        })


        $(document).on('change', "#identity_type",function (){
            let value = $(this).find('option:selected').val();
                    window.location.href = "<?php echo e(route('user.profile')); ?>/?identity_type=" + value
        });

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/redhosta/demo.redhosta.com/min/resources/views/themes/royalblue/user/profile/myprofile.blade.php ENDPATH**/ ?>