<?php $__env->startSection('title'); ?>
    <?php echo e(trans($page_title)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="container-fluid">


        <div class="row">
            <div class="col-12">
                <div class="card card-primary shadow">
                    <div class="card-body">
                        <?php if(adminAccessRoute(config('role.mining_operation.access.add'))): ?>
                        <a href="<?php echo e(route('admin.manage-plan.create')); ?>"
                                class="btn btn-success btn-sm float-right mb-3"><i
                                class="fa fa-plus-circle"></i> <?php echo e(trans('Add New')); ?>

                        </a>
                        <?php endif; ?>

                        <div class="table-responsive p-3">
                        <table class="table table-striped" <?php if(count($list) > 0): ?> id="dataTable" <?php endif; ?>>
                            <thead class="thead-dark">
                            <tr>
                                <th scope="col"><?php echo app('translator')->get('Image'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Name'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Miner'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Price'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Hashrate'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Duration'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Profit'); ?> <small>(<?php echo app('translator')->get('per day'); ?>)</small></th>
                                <th scope="col"><?php echo app('translator')->get('Referral Bonus'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                                <?php if(adminAccessRoute(config('role.mining_operation.access.edit'))): ?>
                                <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                                <?php endif; ?>
                            </tr>

                            </thead>
                            <tbody id="sortable">
                            <?php if(count($list) > 0): ?>
                                <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $obj): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td data-label="<?php echo app('translator')->get('Image'); ?>"><img src="<?php echo e(getFile(config('location.plan.path'). $obj->image)); ?>"  alt="<?php echo e($obj->name); ?>" class="max-width-40 img-circle"> </td>
                                        <td data-label="<?php echo app('translator')->get('Name'); ?>"><?php echo e($obj->name); ?> </td>
                                        <td data-label="<?php echo app('translator')->get('Miner'); ?>" class="font-weight-bold"><?php echo e(optional($obj->miner)->code); ?> </td>
                                        <td data-label="<?php echo app('translator')->get('Price'); ?>"><?php echo app('translator')->get(config('basic.currency_symbol')); ?><?php echo e($obj->price); ?> </td>
                                        <td data-label="<?php echo app('translator')->get('Hashrate'); ?>"><?php echo e($obj->hash_rate_speed); ?> <?php echo e($obj->hash_rate_unit); ?> </td>
                                        <td data-label="<?php echo app('translator')->get('Duration'); ?>"><?php echo e($obj->duration); ?> <?php echo e($obj->periodText); ?> </td>
                                        <td data-label="<?php echo app('translator')->get('Profit'); ?>"><?php echo e(getAmount($obj->minimum_profit,8)); ?> - <?php echo e(getAmount($obj->minimum_profit,8)); ?> </td>
                                        <td data-label="<?php echo app('translator')->get('Referral Bonus'); ?>"><?php echo e($obj->referral); ?><?php echo app('translator')->get('%'); ?> </td>

                                        <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                            <?php echo $obj->status == 1 ? '<span class="badge badge-success badge-pill">'.trans('Active').'</span>' : '<span class="badge badge-danger badge-pill">'.trans('Inactive').'</span>'; ?>

                                        </td>

                                        <?php if(adminAccessRoute(config('role.mining_operation.access.edit'))): ?>
                                        <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                            <a href="<?php echo e(route('admin.manage-plan.edit',$obj)); ?>"
                                                    class="btn btn-sm btn-primary btn-circle"><i
                                                    class="fa fa-pencil-alt"></i>
                                            </a>
                                        </td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <tr>
                                    <td class="text-center text-danger" colspan="100%">
                                        <?php echo app('translator')->get('No Data Found'); ?>
                                    </td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/dataTables.bootstrap4.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/dataTables.bootstrap4.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>

    <script>
        $(document).ready(function () {
            $('#dataTable').DataTable(); // ID From dataTable

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\server\htdocs\codecanyon-D9E8xWGL-minestack-a-digital-mining-platform\project\resources\views/admin/plan/index.blade.php ENDPATH**/ ?>