<?php $__env->startSection('title'); ?>
    <?php echo e(trans($page_title)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="container-fluid">


        <div class="row">
            <div class="col-12">
                <?php echo $__env->make('errors.error', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="card card-primary shadow">
                    <div class="card-body">
                        <?php if(adminAccessRoute(config('role.mining_operation.access.add'))): ?>
                        <button type="button"
                                class="btn btn-success btn-sm float-right mb-3"
                                data-toggle="modal" data-target="#newModal"><i
                                class="fa fa-plus-circle"></i> <?php echo e(trans('Add New')); ?>

                        </button>
                        <?php endif; ?>

                        <div class="table-responsive p-3">
                            <table class="table table-striped" <?php if(count($list) > 0): ?> id="dataTable" <?php endif; ?>>
                            <thead class="thead-dark">
                            <tr>
                                <th scope="col"><?php echo app('translator')->get('Name'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Miner Code'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Total Plans'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                                <?php if(adminAccessRoute(config('role.mining_operation.access.edit'))): ?>
                                <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                                <?php endif; ?>
                            </tr>

                            </thead>
                            <tbody id="sortable">
                            <?php if(count($list) > 0): ?>
                                <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $obj): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td data-label="<?php echo app('translator')->get('Name'); ?>"><?php echo e($obj->name); ?> </td>
                                        <td data-label="<?php echo app('translator')->get('Miner Code'); ?>"><?php echo e($obj->code); ?> </td>
                                        <td data-label="<?php echo app('translator')->get('Total Plan'); ?>">
                                            <span class="badge badge-light"><?php echo e($obj->plans_count); ?></span>
                                        </td>
                                        <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                            <?php echo $obj->status == 1 ? '<span class="badge badge-success badge-pill">'.trans('Active').'</span>' : '<span class="badge badge-danger badge-pill">'.trans('Inactive').'</span>'; ?>

                                        </td>

                                        <?php if(adminAccessRoute(config('role.mining_operation.access.edit'))): ?>
                                        <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                            <button type="button"
                                                    data-route="<?php echo e(route('admin.mining.update',$obj)); ?>"
                                                    data-resource="<?php echo e($obj); ?>"
                                                    class="btn btn-sm btn-primary  btn-circle changeBtn"
                                                    data-toggle="modal" data-target="#updateModal"><i
                                                    class="fa fa-pencil-alt"></i>
                                            </button>
                                        </td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <tr>
                                    <td class="text-center text-danger" colspan="100%">
                                        <?php echo app('translator')->get('No Data Found'); ?>
                                    </td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>


    <div id="newModal" data-backdrop="static" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header modal-colored-header bg-primary">
                    <h5 class="modal-title"><i class="fa fa-plus-circle"></i> <?php echo app('translator')->get('Add New Miner'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.mining.add')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="name"><?php echo app('translator')->get('Miner Name'); ?></label>
                            <input type="text" class="form-control" id="name" name="name" value="<?php echo e(old('name')); ?>"
                                   placeholder="<?php echo app('translator')->get('Enter Miner Name'); ?>">
                        </div>
                        <div class="form-group">
                            <label for="code"><?php echo app('translator')->get('Miner Code'); ?></label>
                            <input type="text" class="form-control" id="code" name="code" value="<?php echo e(old('code')); ?>"
                                   placeholder="<?php echo app('translator')->get('Enter Miner Code'); ?>">
                        </div>

                        <div class="form-group">
                            <label for="minimum_amount"><?php echo app('translator')->get('Minimum Payout Amount'); ?></label>
                            <input type="text" class="form-control" id="minimum_amount" name="minimum_amount"
                                   value="<?php echo e(old('minimum_amount')); ?>" placeholder="<?php echo app('translator')->get('Minimum Amount'); ?>">
                        </div>

                        <div class="form-group">
                            <label for="maximum_amount"><?php echo app('translator')->get('Maximum Payout Amount'); ?></label>
                            <input type="text" class="form-control" id="maximum_amount" name="maximum_amount"
                                   value="<?php echo e(old('maximum_amount')); ?>" placeholder="<?php echo app('translator')->get('Maximum Amount'); ?>">
                        </div>

                        <div class="form-group">
                            <label for="status"><?php echo app('translator')->get('Status'); ?></label>
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="status" name="status" value="1">
                                <label class="custom-control-label" for="status"><?php echo app('translator')->get('Active'); ?></label>
                            </div>
                        </div>


                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Save'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <div id="updateModal"  data-backdrop="static" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header modal-colored-header bg-primary">
                    <h5 class="modal-title"><i class="fa fa-pencil-alt"></i> <?php echo app('translator')->get('Edit Miner'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                    <form action="" method="POST" class="updateForm">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('put'); ?>
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="name"><?php echo app('translator')->get('Miner Name'); ?></label>
                                <input type="text" class="form-control" id="name" name="name" value="<?php echo e(old('name')); ?>"
                                       placeholder="<?php echo app('translator')->get('Enter Miner Name'); ?>">
                            </div>
                            <div class="form-group">
                                <label for="code"><?php echo app('translator')->get('Miner Code'); ?></label>
                                <input type="text" class="form-control" id="code" name="code" value="<?php echo e(old('code')); ?>"
                                       placeholder="<?php echo app('translator')->get('Enter Miner Code'); ?>">
                            </div>

                            <div class="form-group">
                                <label for="minimum_amount"><?php echo app('translator')->get('Minimum Payout Amount'); ?></label>
                                <input type="text" class="form-control" id="minimum_amount" name="minimum_amount"
                                       value="<?php echo e(old('minimum_amount')); ?>" placeholder="<?php echo app('translator')->get('Minimum Amount'); ?>">
                            </div>

                            <div class="form-group">
                                <label for="maximum_amount"><?php echo app('translator')->get('Maximum Payout Amount'); ?></label>
                                <input type="text" class="form-control" id="maximum_amount" name="maximum_amount"
                                       value="<?php echo e(old('maximum_amount')); ?>" placeholder="<?php echo app('translator')->get('Maximum Amount'); ?>">
                            </div>

                            <div class="form-group">
                                <label for="edit_status"><?php echo app('translator')->get('Status'); ?></label>
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" id="edit_status" name="status" value="1">
                                    <label class="custom-control-label" for="edit_status"><?php echo app('translator')->get('Active'); ?></label>
                                </div>
                            </div>


                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                            <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Update'); ?></button>
                        </div>
                    </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/dataTables.bootstrap4.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/dataTables.bootstrap4.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        $(document).ready(function () {
            $('#dataTable').DataTable(); // ID From dataTable
        });
    </script>

    <script>
        "use strict";
        $(document).on('click','.changeBtn', function () {
            var route = $(this).data('route');
            var resource = $(this).data('resource');
            var modal = $('#updateModal');
            modal.find('form').attr('action',route);
            modal.find('input[name=name]').val(resource.name);
            modal.find('input[name=code]').val(resource.code);
            modal.find('input[name=minimum_amount]').val(resource.minimum_amount);
            modal.find('input[name=maximum_amount]').val(resource.maximum_amount);
            if(resource.status == 1){
                $('#edit_status').attr('checked', true)
            }else{
                $('#edit_status').attr('checked', false)
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/redhosta/demo.redhosta.com/min/resources/views/admin/mining_list/index.blade.php ENDPATH**/ ?>