<?php $__env->startSection('title',trans('Dashboard')); ?>
<?php $__env->startSection('content'); ?>


    <!-- Dashboard Starts Here -->
    <div class="dashboard-section padding-top padding-bottom">
        <div class="container">

            <div class="row justify-content-center g-4">
                <div class="col-xl-3 col-lg-4 col-md-6 col-sm-10">
                    <div class="dashboard__card">
                        <div class="dashboard__card-content">
                            <h2 class="price"><sup><?php echo app('translator')->get(config('basic.currency_symbol')); ?></sup><?php echo e($walletBalance); ?></h2>
                            <p class="info"><?php echo app('translator')->get(config('basic.currency')); ?> <?php echo app('translator')->get('Balance'); ?></p>
                        </div>
                        <div class="dashboard__card-icon">
                            <img src="<?php echo e(asset('assets/crypto/WALLET.png')); ?>" alt="...">
                        </div>
                    </div>
                </div>

                <?php $__currentLoopData = $wallets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wallet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-3 col-lg-4 col-md-6 col-sm-10">
                            <div class="dashboard__card dashboard__card-<?php echo e(strtoupper($wallet->code)); ?>">
                                <div class="dashboard__card-content">
                                    <h2 class="price"><?php echo e(getAmount($wallet->balance,8)); ?></h2>
                                    <p class="info"><?php echo e($wallet->code); ?> <?php echo app('translator')->get('Balance'); ?></p>
                                </div>
                                <div class="dashboard__card-icon dashboard__card-icon-<?php echo e(strtoupper($wallet->code)); ?>">
                                    <?php if(file_exists('assets/crypto/'.strtoupper($wallet->code).'.png') ): ?>
                                    <img src="<?php echo e(asset('assets/crypto/'.strtoupper($wallet->code).'.png')); ?>" alt="<?php echo e($wallet->code); ?>">
                                    <?php else: ?>
                                        <img src="<?php echo e(asset('assets/crypto/.png')); ?>" alt="<?php echo e($wallet->code); ?>">
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-3 col-lg-4 col-md-6 col-sm-10">
                    <div class="dashboard__card">
                        <div class="dashboard__card-content">
                            <h2 class="price"><?php echo e($referralMember); ?></h2>
                            <p class="info"> <?php echo app('translator')->get('Referral Member'); ?></p>
                        </div>
                        <div class="dashboard__card-icon">
                            <img src="<?php echo e(asset('assets/crypto/Users.png')); ?>" alt="...">
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-lg-4 col-md-6 col-sm-10">
                    <div class="dashboard__card">
                        <div class="dashboard__card-content">
                            <h2 class="price"><sup><?php echo app('translator')->get(config('basic.currency_symbol')); ?></sup><?php echo e(getAmount($referralBonus, config('basic.fraction_number'))); ?></h2>
                            <p class="info"><?php echo app('translator')->get('Bonus Earned'); ?></p>
                        </div>
                        <div class="dashboard__card-icon">
                            <img src="<?php echo e(asset('assets/crypto/money.png')); ?>" alt="...">
                        </div>
                    </div>
                </div>
            </div>

            <div class="row g-4 mt-50 mb-50">
                <div class="col-xl-8">
                    <div id="container" class="apexcharts-canvas"></div>
                </div>
                <div class="col-xl-4">
                    <div class="card custom--card">
                        <div class="card--header gradient-bg text-center p-3 py-sm-4 px-sm-4">
                            <h4 class="title text-start m-0"><?php echo app('translator')->get("Referral link"); ?></h4>
                        </div>
                        <div class="card--body gradient-bg p-0">
                            <div class="deposit-preview-body p-4">
                                <p>
                                    <?php echo app('translator')->get("Automatically top up your account balance by sharing your referral link, Earn a percentage of whatever plan your referred user buys."); ?>
                                </p>
                                <div class="deposit-group">
                                    <div class="input-group mb-50">
                                        <input type="text"
                                               value="<?php echo e(route('register.sponsor',[Auth::user()->username])); ?>"
                                               class="form--control form-control style--two"
                                               id="sponsorURL"
                                               readonly>
                                        <div class="input-group-append">
                                            <span class="input-group-text form--control copytext" id="copyBoard" onclick="copyFunction()">
                                                    <i class="fa fa-copy"></i>
                                            </span>
                                        </div>

                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="shape shape1">
            <img src="<?php echo e(getFile($themeTrue.'images/about/shape2.png')); ?>" alt="about">
        </div>
    </div>
    <!-- Dashboard Ends Here -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

    <script src="<?php echo e(asset($themeTrue.'js/apexcharts.js')); ?>"></script>


    <script>
        "use strict";

        var options = {
            theme: {
                mode: 'dark',
            },

            series: [
                {
                    name: "<?php echo e(trans('Referral Bonus')); ?>",
                    color: 'rgba(255, 72, 0, 1)',
                    data: <?php echo $monthly['bonus']->flatten(); ?>

                },
                {
                    name: "<?php echo e(trans('Investment')); ?>",
                    color: 'rgb(0,85,255)',
                    data: <?php echo $monthly['invest']->flatten(); ?>

                }
            ],
            chart: {
                type: 'bar',
                // height: ini,
                background: '#131e51',
                toolbar: {
                    show: false
                }

            },
            plotOptions: {
                bar: {
                    horizontal: false,
                    columnWidth: '55%',
                    endingShape: 'rounded'
                },
            },
            dataLabels: {
                enabled: false
            },
            stroke: {
                show: true,
                width: 2,
                colors: ['transparent']
            },
            xaxis: {
                categories: <?php echo $monthly['bonus']->keys(); ?>,

            },
            yaxis: {
                title: {
                    text: ""
                }
            },
            fill: {
                opacity: 1
            },
            tooltip: {
                colors: ['#000'],
                y: {
                    formatter: function (val) {
                        return "<?php echo e(trans($basic->currency_symbol)); ?>" + val + ""
                    }
                }
            }
        };

        var chart = new ApexCharts(document.querySelector("#container"), options);
        chart.render();

        function copyFunction() {
            var copyText = document.getElementById("sponsorURL");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            /*For mobile devices*/
            document.execCommand("copy");
            Notiflix.Notify.Success(`Copied: ${copyText.value}`);
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/redhosta/demo.redhosta.com/min/resources/views/themes/royalblue/user/dashboard.blade.php ENDPATH**/ ?>