<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php echo $__env->make('partials.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@100;200;300;400;500;600;700&family=Open+Sans:wght@300;400&display=swap">
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/lib/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/lib/animate.css')); ?>">
    <?php echo $__env->yieldPushContent('css-lib'); ?>

    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/line-awesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/all.min.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/lib/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/lib/odometer.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/main.css')); ?>">
    <?php echo $__env->yieldPushContent('style'); ?>

</head>
<body>

<div class="overlay"></div>
<a href="javascript:void(0)" class="scrollToTop"><i class="las la-chevron-up"></i></a>

<div class="header">
    <div class="header-bottom">
        <div class="container">
            <div class="header-bottom-area" id="pushNotificationArea">
                <div class="logo">
                    <a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(getFile(config('location.logoIcon.path').'logo.png')); ?>"
                                                alt="<?php echo e(config('basic.site_title')); ?>"></a>
                </div>
                <ul class="menu">
                    <li>
                        <a href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a>
                    </li>


                    <li class="d-lg-none d-block "><a href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a></li>
                    <li>
                        <a href="javascript:void(0)"><?php echo app('translator')->get('Plan'); ?></a>
                        <ul class="sub-menu">
                            <li><a href="<?php echo e(route('plan')); ?>"><?php echo app('translator')->get('Plan List'); ?></a></li>
                            <li><a href="<?php echo e(route('user.plan-log')); ?>"><?php echo app('translator')->get('Purchase Log'); ?></a></li>
                        </ul>
                    </li>
                    <li>
                        <a href="javascript:void(0)"><?php echo app('translator')->get('Fund'); ?></a>
                        <ul class="sub-menu">
                            <li><a href="<?php echo e(route('user.addFund')); ?>"><?php echo app('translator')->get('Add Fund'); ?></a></li>
                            <li><a href="<?php echo e(route('user.fund-history')); ?>"><?php echo app('translator')->get('Payment Log'); ?></a></li>
                        </ul>
                    </li>

                    <li>
                        <a href="javascript:void(0)"><?php echo app('translator')->get('Payout'); ?></a>
                        <ul class="sub-menu">
                            <li><a href="<?php echo e(route('user.payout.money')); ?>"><?php echo app('translator')->get('Payout Now'); ?></a></li>
                            <li><a href="<?php echo e(route('user.payout.history')); ?>"><?php echo app('translator')->get('Payout History'); ?></a></li>
                        </ul>
                    </li>

                    <li class="d-lg-none d-block "><a href="<?php echo e(route('user.transaction')); ?>"><?php echo app('translator')->get('Transaction'); ?></a></li>
                    <li class="d-lg-none d-block "><a href="<?php echo e(route('user.wallet')); ?>"><?php echo app('translator')->get('Wallets'); ?></a></li>
                    <li class="d-lg-none d-block "><a href="<?php echo e(route('user.profile')); ?>"><?php echo app('translator')->get('Profile Settings'); ?></a>
                    </li>
                    <li class="d-lg-none d-block "><a href="<?php echo e(route('user.referral')); ?>"><?php echo app('translator')->get('My Referral'); ?></a></li>
                    <li class="d-lg-none d-block "><a href="<?php echo e(route('user.ticket.list')); ?>"><?php echo app('translator')->get('Support Ticket'); ?></a>
                    </li>
                    <li class="d-lg-none d-block "><a
                            href="<?php echo e(route('user.twostep.security')); ?>"><?php echo app('translator')->get('2FA Security'); ?></a></li>
                    <li class="d-lg-none d-block "><a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                         document.getElementById('logout-form').submit();"><?php echo app('translator')->get('Logout'); ?></a></li>


                    <?php if(auth()->guard()->check()): ?>
                        <li class="p-0 d-none d-lg-block mx-lg-3 my-2">
                            <a href="javascript:void(0)" class="dashboard-link p-0"><img
                                    src="<?php echo e(getFile(config('location.user.path').auth()->user()->image)); ?>"
                                    alt="dashboard-link"></a>
                            <ul class="sub-menu">
                                <li><a href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a></li>
                                <li><a href="<?php echo e(route('user.transaction')); ?>"><?php echo app('translator')->get('Transaction'); ?></a></li>
                                <li><a href="<?php echo e(route('user.wallet')); ?>"><?php echo app('translator')->get('Wallets'); ?></a></li>
                                <li><a href="<?php echo e(route('user.profile')); ?>"><?php echo app('translator')->get('Profile Settings'); ?></a></li>
                                <li><a href="<?php echo e(route('user.referral')); ?>"><?php echo app('translator')->get('My Referral'); ?></a></li>
                                <li><a href="<?php echo e(route('user.ticket.list')); ?>"><?php echo app('translator')->get('Support Ticket'); ?></a></li>
                                <li><a href="<?php echo e(route('user.twostep.security')); ?>"><?php echo app('translator')->get('2FA Security'); ?></a></li>
                                <li><a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                         document.getElementById('logout-form').submit();"><?php echo app('translator')->get('Logout'); ?></a></li>
                            </ul>
                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                <?php echo csrf_field(); ?>
                            </form>
                        </li>
                        <li class="p-0 d-none d-lg-block mx-lg-3 my-2">
                            <?php echo $__env->make($theme.'partials.pushNotify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </li>
                    <?php endif; ?>

                </ul>

                <div class="header-trigger-wrapper d-flex d-lg-none align-items-center">
                    <?php if(auth()->guard()->check()): ?>
                        <div class="p-0  d-lg-block mx-lg-3 my-2">
                            <a href="javascript:void(0)" class="dashboard-link mobile p-0"><img
                                    src="<?php echo e(getFile(config('location.user.path').auth()->user()->image)); ?>"
                                    alt="dashboard-link"></a>

                        </div>
                        <div class="p-0  d-lg-block mx-3 my-2">
                            <?php echo $__env->make($theme.'partials.pushNotify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    <?php endif; ?>

                    <div class="header-trigger d-block d--none">
                        <span></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php echo $__env->make($theme.'partials.banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->yieldContent('content'); ?>


<?php echo $__env->make($theme.'partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<?php echo $__env->yieldPushContent('extra-content'); ?>
<?php echo $__env->yieldPushContent('loadModal'); ?>

<!-- jQuery library -->
<script src="<?php echo e(asset($themeTrue.'js/lib/jquery-3.6.0.min.js')); ?>"></script>
<!-- bootstrap 5 js -->
<script src="<?php echo e(asset($themeTrue.'js/lib/bootstrap.min.js')); ?>"></script>
<?php echo $__env->yieldPushContent('extra-js'); ?>
<!-- Pluglin Link -->
<script src="<?php echo e(asset($themeTrue.'js/lib/slick.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/lib/odometer.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/lib/viewport.jquery.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/notiflix-aio-2.7.0.min.js')); ?>"></script>

<script src="<?php echo e(asset($themeTrue.'js/pusher.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/vue.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/axios.min.js')); ?>"></script>


<!-- main js -->
<script src="<?php echo e(asset($themeTrue.'js/main.js')); ?>"></script>

<?php if(auth()->guard()->check()): ?>
    <script>
        'use strict';
        let pushNotificationArea = new Vue({
            el: "#pushNotificationArea",
            data: {
                items: [],
            },
            mounted() {
                this.getNotifications();
                this.pushNewItem();

                $('.notification-toggler').on('click', function () {
                    $('.dropdown-wrapper').hide(300);
                    if ($('.dropdown-wrapper').hasClass('active')) {
                        $('.dropdown-wrapper').removeClass('active')
                    } else {
                        $('.dropdown-wrapper').addClass('active')
                        $('.dropdown-wrapper').show(300);
                    }
                    $('.overlay').addClass('active');
                });

                // Responsive Menu
                var headerTrigger = $('.header-trigger');
                headerTrigger.on('click', function () {
                    $('.menu, .header-trigger').toggleClass('active')
                    $('.overlay').toggleClass('active')
                });

                //Menu Dropdown
                $("ul>li>.sub-menu").parent("li").addClass("has-sub-menu");


                $('.menu li a').on('click', function () {
                    var element = $(this).parent('li');
                    if (element.hasClass('open')) {
                        element.removeClass('open');
                        element.find('li').removeClass('open');
                        element.find('ul').slideUp(300, "swing");
                    } else {
                        element.addClass('open');
                        element.children('ul').slideDown(300, "swing");
                        element.siblings('li').children('ul').slideUp(300, "swing");
                        element.siblings('li').removeClass('open');
                        element.siblings('li').find('li').removeClass('open');
                        element.siblings('li').find('ul').slideUp(300, "swing");
                    }
                });
            },
            methods: {
                getNotifications() {
                    let app = this;
                    axios.get("<?php echo e(route('user.push.notification.show')); ?>")
                        .then(function (res) {
                            app.items = res.data;
                        })
                },
                readAt(id, link) {
                    let app = this;
                    let url = "<?php echo e(route('user.push.notification.readAt', 0)); ?>";
                    url = url.replace(/.$/, id);
                    axios.get(url)
                        .then(function (res) {
                            if (res.status) {
                                app.getNotifications();
                                if (link != '#') {
                                    window.location.href = link
                                }
                            }
                        })
                },
                readAll() {
                    let app = this;
                    let url = "<?php echo e(route('user.push.notification.readAll')); ?>";
                    axios.get(url)
                        .then(function (res) {
                            if (res.status) {
                                app.items = [];
                            }
                        })
                },
                pushNewItem() {
                    let app = this;
                    // Pusher.logToConsole = true;
                    let pusher = new Pusher("<?php echo e(env('PUSHER_APP_KEY')); ?>", {
                        encrypted: true,
                        cluster: "<?php echo e(env('PUSHER_APP_CLUSTER')); ?>"
                    });
                    let channel = pusher.subscribe('user-notification.' + "<?php echo e(Auth::id()); ?>");
                    channel.bind('App\\Events\\UserNotification', function (data) {
                        app.items.unshift(data.message);
                    });
                    channel.bind('App\\Events\\UpdateUserNotification', function (data) {
                        app.getNotifications();
                    });
                }
            }
        });
    </script>

<?php endif; ?>
<?php echo $__env->yieldPushContent('script'); ?>

<?php echo $__env->make($theme.'partials.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<?php echo $__env->make('plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>
</html>
<?php /**PATH /home/redhosta/demo.redhosta.com/min/resources/views/themes/royalblue/layouts/user.blade.php ENDPATH**/ ?>